<?php /* Template Name: Parent Page - Home */ ?>
<?php get_header(); ?>
<section id="content-parent" role="main" class="test01">
    <?php $termsOfTaxonomyGroup = get_terms( 'strona-glowna' ); ?>
    <?php ksort($termsOfTaxonomyGroup); ?>
    <?php $termsNumb = 0; ?>
    <?php foreach($termsOfTaxonomyGroup as $term) : ?>
        <?php $termsNumb++; ?>
        <?php
        $termClass = $term->slug;
        $termName = $term->name;
        $termID = $term->term_id;
        $postID = $post->ID;
        $args = array(
            'sort_order' => 'ASC',
            'sort_column' => 'menu_order',
            'hierarchical' => 1,
            'child_of' => $postID,
            'tax_query' => array(
                array(
                    'taxonomy' => 'group',
                    'field' => 'id',
                    'terms' => $termID
                    //'orderby' => 'custom_sort',
                    //'order'=> 'ASC'
                )
            ),
            'offset' => 0,
            'post_type' => 'page',
            'post_status' => 'publish'
        );
        $counter = 0;
       // add_filter( 'posts_orderby', 'filter_query' );
        $query = new WP_Query( $args );
      //  remove_filter( 'posts_orderby', 'filter_query' );

        ?>
        <?php if ($query) : ?>
            <div class="<?php echo $termClass; ?> page-subtitle">
                <div class="page-subtitle-in">
                    <h2><?php echo $termName; ?></h2>
                </div>
            </div>
            <div class="content container <?php echo $termClass; ?>-in <?php if($termsNumb % 2 == 0) : ?>reverse-term<?php endif; ?>">
                <ul>
                    <div class="cycle-slideshow col-md-offset-0 col-md-12 col-sm-offset-0 col-sm-12 col-xs-offset-1 col-xs-10"
                         data-cycle-speed="600"
                         data-cycle-manual-speed="1000"
                         data-cycle-timeout="15000"
                         data-cycle-auto-height="calc"
                         data-cycle-prev=".prev-<?php echo $termClass?>"
                         data-cycle-next=".next-<?php echo $termClass?>"
                         data-fx=scrollHorz
                         data-cycle-slides=".sp-<?php echo $termClass?>"
                         data-pager="> .cycle-pager-<?php echo $termClass?>"
                         data-pause-on-hover=true>
                        <?php foreach( $query->posts as $page ) : ?>
                            <?php $counter++;
                                if ($counter < 10)
                                {
                                    $newCounter = 0 . $counter;
                                } else {
                                    $newCounter = $counter;
                                };
                            ?>
                            <li class="sp-<?php echo $termClass?> <?php if ($counter % 2 == 0) : ?>even<?php endif; ?>">
                                <div class="row content-in">
                                    <div class="col-md-5 col-sm-12 col-xs-12 reverse">
                                        <?php if($page->post_content) : ?>
                                        <h3><a href="<?php echo get_page_link( $page->ID ); ?>"><?php echo $page->post_title; ?></a></h3>
                                        <?php else : ?>
                                            <h3><?php echo $page->post_title; ?></h3>
                                        <?php endif; ?>
                                        <div class="counter">
                                            <?php echo $newCounter; ?>
                                            <div class="revert-line"></div>
                                        </div>
                                        <div class="excrpt">
                                            <?php  echo $page->post_excerpt; ?>
                                        </div>
                                        <?php if($page->post_content): ?>
                                        <a href="<?php echo get_page_link( $page->ID ); ?>">
                                            <div class="know-btn"><?php _e('Poznaj kolejny krok','l4w'); ?></div>
                                        </a>
                                        <?php endif; ?>
                                    </div>
                                    <div class="col-md-7 col-sm-12 reverse res-image">
                                        <?php echo get_the_post_thumbnail( $page->ID ); ?>
                                    </div>
                                    <div class="clearfix"></div>
                                </div>
                            </li>
                        <?php endforeach; ?>
                        <?php if($counter > 1) : ?>
                            <div class="cycle-pager cycle-pager-<?php echo $termClass?>"></div>
                        <?php endif; ?>
                    </div>
                    <?php if($counter > 1) : ?>
                        <div id="prev" class="navi prev-<?php echo $termClass?>"></div>
                        <div id="next" class="navi next-<?php echo $termClass?>"></div>
                    <?php endif; ?>
                </ul>
            </div>
        <?php endif; ?>
    <?php endforeach; ?>
</section>
<?php get_sidebar(); ?>
<?php get_footer(); ?>