﻿<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo( 'charset' ); ?>" />
   <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no">   <title><?php wp_title( ' | ', true, 'right' ); ?></title>
    <link rel="stylesheet" type="text/css" href="<?php echo get_stylesheet_uri(); ?>?=0.1.21" />
    <link href='https://fonts.googleapis.com/css?family=Lato:400,100,100italic,300,300italic,400italic,700italic,700,900italic,900&subset=latin,latin-ext' rel='stylesheet' type='text/css'>
    <link rel="shortcut icon" type="image/vnd.microsoft.icon" href="https://iqsolution.pl/wp-content/themes/iqsolutions/images/iq_logo_16x16.ico" />
    <script>
        if (navigator.userAgent.match(/IEMobile\/10\.0/)) {
            var msViewportStyle = document.createElement("style");
            msViewportStyle.appendChild(
                document.createTextNode(
                    "@-ms-viewport{width:auto!important}"
                )
            );
            document.getElementsByTagName("head")[0].
                appendChild(msViewportStyle);
        }
    </script>
    <?php wp_head(); ?>
    <!-- <script type="text/javascript" src="<?php bloginfo('template_url'); ?>/js/jquery.cycle2.min.js"></script>
    <script type="text/javascript" src="<?php bloginfo('template_url'); ?>/js/jquery.cycle2.carousel.min.js"></script> -->
    <script type="text/javascript" src="<?php bloginfo('template_url'); ?>/js/scripts.js"></script>

</head>
<body <?php body_class(); ?>>
<div id="wrapper" class="hfeed">
    <header id="header" class="container">

        <div class="header-inner">
            <section id="branding">
                <div class="logo"><a href="<?php echo home_url(); ?>" >
                        <img src="<?php echo get_stylesheet_directory_uri(); ?>/images/logo_new.png" alt="IQ Solution" />
                    </a>
                </div>
            </section>
            <div class="logregtop">
                <ul class="language">
                    <li class="left-click"><a></a></li>
                    <li class="current"><a href="<?php echo network_site_url(''); ?>">PL</a></li>
                    <li><a href="<?php echo network_site_url('en'); ?>">EN</a></li>
                    <li><a href="<?php echo network_site_url('de'); ?>">DE</a></li>
                    <li><a href="<?php echo network_site_url('fr'); ?>">FR</a></li>

                </ul>
<!--                <div class="logregtopin">-->
<!--                    --><?php //if ( is_user_logged_in() ) { echo '<a class="button logout" href="'. wp_logout_url() .'">Wyloguj</a>'; }
//                    else { echo '<a class="button login" href="/wp-login.php">Zaloguj się</a><a class="button register" href="/wp-login.php?action=register" class="">Załóż konto</a>'; } ?>
<!--                </div>-->

            </div>

            <nav id="menu" role="navigation" >
                <div class="menuline"></div>
                <div class="menu-responsive"><p><a class="bg"></a><a class="title"><?php the_title(); ?></a></p></div>
                <?php wp_nav_menu( array( 'theme_location' => 'main-menu', 'container_class' => 'menu' ) ); ?>
            </nav>

        </div>

    </header>


<div id="container">

