<?php
/*
Template Name: Contact
*/
?>

<?php
if(isset($_POST['submitted'])) {
    if(trim($_POST['contactName']) === '') {
        $nameError = esc_attr( get_option('translate_17') );
        $hasError = true;
    } else {
        $name = trim($_POST['contactName']);
    }

    if(trim($_POST['email']) === '')  {
        $emailError = esc_attr( get_option('translate_18') );
        $hasError = true;
    } else if (!preg_match("/^[[:alnum:]][a-z0-9_.-]*@[a-z0-9.-]+\.[a-z]{2,4}$/i", trim($_POST['email']))) {
        $emailError = esc_attr( get_option('translate_19') );
        $hasError = true;
    } else {
        $email = trim($_POST['email']);
    }

    if(trim($_POST['comments']) === '') {
        $commentError = esc_attr( get_option('translate_20') );
        $hasError = true;
    } else {
        if(function_exists('stripslashes')) {
            $comments = stripslashes(trim($_POST['comments']));
        } else {
            $comments = trim($_POST['comments']);
        }
    }

    if(!isset($hasError)) {
        $emailTo = get_option('tz_email');
        if (!isset($emailTo) || ($emailTo == '') ){
            $emailTo = get_option('admin_email');
        }
        $subject = 'Zapytanie z formularza strony iqsolution.pl '.$name;
        $body = "Name: $name \n\nEmail: $email \n\nComments: $comments";
        $headers = 'From: '.$name.' <'.$emailTo.'>' . "\r\n" . 'Reply-To: ' . $email;

        wp_mail($emailTo, $subject, $body, $headers);
        $emailSent = true;
    }

} ?>
<?php get_header(); ?>
<div class="kontakt page-subtitle">
                <div class="page-subtitle-in">
                    <h2><?php echo esc_attr( get_option('translate_23') ); ?></h2>
                </div>
                </div>
        <section id="content" class="contact new-content">

                    <div class="entry-content">
                        <?php if(isset($emailSent) && $emailSent == true) { ?>
                            <div class="thanks">
                                <p><?php echo esc_attr( get_option('translate_16') ); ?>
                                    </p>
                            </div>
                        <?php } else { ?>
                            <?php the_content(); ?>
                            <?php if(isset($hasError) || isset($captchaError)) { ?>
                                <p class="error"><?php echo esc_attr( get_option('translate_15') ); ?><p>
                            <?php } ?>
                                <div class="row">
                                <div class="col-xs-12" style="padding: 0px 15px 50px 15px;">
                                <div class="contactform">
                                    <div class="col-xs-2 hidden-xs">
                                <div class="form-icon"></div>
                                    </div>
                                    <div class="col-xs-12 col-sm-10">
                                    <h2><?php echo esc_attr( get_option('translate_24') ); ?></h2>
                                    <hr>
                            <form action="<?php the_permalink(); ?>" id="contactForm" method="post">
                                    <div class="col-md-6 col-xs-12" style="padding:0">
                                    <div class="form-group">
                                        <input type="text" placeholder="<?php echo esc_attr( get_option('translate_14') ); ?>" name="contactName" id="contactName" value="<?php if(isset($_POST['contactName'])) echo $_POST['contactName'];?>" class="required form-control requiredField" />
                                        <?php if($nameError != '') { ?>
                                            <span class="error"><?=$nameError;?></span>
                                        <?php } ?>
                                        </div>


                                        <div class="form-group">
                                  
                                        <input type="text" placeholder="<?php echo esc_attr( get_option('translate_13') ); ?>" name="email" id="email" value="<?php if(isset($_POST['email']))  echo $_POST['email'];?>" class="required form-control requiredField email" />
                                        <?php if($emailError != '') { ?>
                                            <span class="error"><?=$emailError;?></span>
                                        <?php } ?>
                                        </div>
                                   
                                        </div>
                                        <div class="col-md-6 col-xs-12">
                                    <div class="form-group">
                                            
                                        <textarea  placeholder="<?php echo esc_attr( get_option('translate_12') ); ?>" name="comments" id="commentsText" rows="7" cols="30" class="required form-control requiredField"><?php if(isset($_POST['comments'])) { if(function_exists('stripslashes')) { echo stripslashes($_POST['comments']); } else { echo $_POST['comments']; } } ?></textarea>
                                        <?php if($commentError != '') { ?>
                                            <span class="error"><?=$commentError;?></span>
                                        <?php } ?>
                                        </div>
                                
                                    </div>
                                    </div>

                                   
                                    <div class="col-xs-12">
                                       
                             
                                        <button class="button" type="submit" title="wyślij" ><?php echo esc_attr( get_option('translate_11') ); ?></button>
                                <input type="hidden" name="submitted" id="submitted" value="true" />
                                </div>
                            </form>
                            </div>
                            </div>
                            
                            
                            
                        <?php } ?>
                </div><!-- .post -->

        </section><!-- #content -->

<?php get_sidebar(); ?>
<?php get_footer(); ?>